//
//  B5TemplateProperties.h
//  ApplicationFrameworks
//
//  Created by Kevin Hayes on 2015-05-19.
//
//

#import <Foundation/Foundation.h>

typedef NS_ENUM(NSInteger, B5TemplateState) {
	B5TemplateStateAvailable = 0,
	B5TemplateStateHidden,
	B5TemplateStateDeleted,
};

@interface B5TemplateProperties : NSObject <NSSecureCoding>

@property (nonatomic, strong) NSString *title;
@property (nonatomic, strong) NSString *uuid;
@property (nonatomic, strong) NSString *pluralTitle;
@property (nonatomic, strong) NSString *templateDescription;
@property (nonatomic, assign) B5TemplateState state;

- (instancetype) initWithTemplateDictionary:(NSDictionary *)templateDictionary;

@end
